
import xml.etree.ElementTree as ET
import pandas as pd
import tkinter as tk
from tkinter import filedialog, messagebox
import importlib.util

def check_openpyxl_installed():
    return importlib.util.find_spec("openpyxl") is not None

def extract_bom(node, level=0, parent_code=""):
    code = ""
    for child in node:
        if child.tag == "Property" and child.attrib.get("Name") == "CODE":
            code = child.attrib.get("Value")
            break
    current_code = code if code else node.attrib.get("Name", "")
    results = [(level, parent_code, current_code)]

    for child in node.findall("Node"):
        results.extend(extract_bom(child, level + 1, current_code))
    return results

def convert_xml_to_excel(filepath):
    tree = ET.parse(filepath)
    root = tree.getroot()

    bom_data = []
    for node in root.findall(".//Node"):
        if "Name" in node.attrib:
            bom_data.extend(extract_bom(node))
            break

    df = pd.DataFrame(bom_data, columns=["Level", "Parent", "Code"])

    # Varmistetaan tiedostopääte oikein
    lower_filepath = filepath.lower()
    if lower_filepath.endswith(".xml"):
        output_path = filepath[:-(len(".xml"))] + "_bom.xlsx"
    else:
        output_path = filepath + "_bom.xlsx"

    df.to_excel(output_path, index=False, engine="openpyxl")
    return output_path

def browse_file():
    if not check_openpyxl_installed():
        messagebox.showerror("Puuttuva kirjasto", "Ohjelma tarvitsee 'openpyxl'-kirjaston. Asenna se komennolla:\npip install openpyxl")
        return

    filepath = filedialog.askopenfilename(filetypes=[("XML files", "*.xml;*.XML")])
    if filepath:
        try:
            output = convert_xml_to_excel(filepath)
            messagebox.showinfo("Valmis", f"Tiedosto tallennettu:\n{output}")
        except Exception as e:
            messagebox.showerror("Virhe", str(e))

app = tk.Tk()
app.title("XML → Excel BOM-muunnin")

label = tk.Label(app, text="Valitse .xml-tiedosto")
label.pack(pady=10)

button = tk.Button(app, text="Valitse tiedosto", command=browse_file)
button.pack(pady=5)

app.mainloop()
